﻿using Microsoft.Extensions.Configuration;
using Newtonsoft.Json.Linq;
using OllamaSharp;

namespace OllamaChatAgent;

public partial class Form1 : Form
{
    private const string JsonConfig = "jsconfig.json";
    private Chat _chat;
    private OllamaApiClient? _ollamaApiClient;

    public Form1()
    {
        InitializeComponent();

        if (File.Exists(JsonConfig))
        {
            IConfigurationRoot configuration = new ConfigurationBuilder()
                .AddJsonFile(JsonConfig)
                .Build();

            string? modelValue = configuration.GetSection("model").Value;
            if (modelValue is not null) txtModel.Text = modelValue;

            string? uriValue = configuration.GetSection("uri").Value;
            if (uriValue is not null) txtOllamaUri.Text = uriValue;
        }
    }

    private async void btnSend_Click(object sender, EventArgs e)
    {
        if (_ollamaApiClient is null)
        {
            txtAnswer.Clear();
            txtAnswer.AppendText("Ollama client is not created, please create it first!");
        }
        else
        {
            txtAnswer.Clear();

            await foreach (var answerToken in _chat.SendAsync(txtMessage.Text))
            {
                var normalized = answerToken
                    .Replace("\r\n", "\n")
                    .Replace("\r", "\n")
                    .Replace("\n", Environment.NewLine);

                txtAnswer.AppendText(normalized);
            }

            txtMessage.Clear();
        }
    }

    private void btnCreateOllamaClient_Click(object sender, EventArgs e)
    {
        var uri = new Uri(txtOllamaUri.Text);
        _ollamaApiClient = new OllamaApiClient(uri);
        _ollamaApiClient.SelectedModel = txtModel.Text;

        _chat = new Chat(_ollamaApiClient);

        txtAnswer.Clear();
        txtAnswer.AppendText($"Ollama client with model: {txtModel.Text} and uri: {txtOllamaUri.Text} created. {Environment.NewLine}");
    }

    private void TbLeave(object sender, EventArgs e)
    {
        var jsonConfig = new JObject
        {
            ["model"] = txtModel.Text,
            ["uri"] = txtOllamaUri.Text
        };
        File.WriteAllText(JsonConfig, jsonConfig.ToString());
    }
}