package com.example.testsandbox

import android.Manifest
import android.app.Activity
import android.content.Context.LOCATION_SERVICE
import android.content.pm.PackageManager
import android.location.LocationListener
import android.location.LocationManager
import androidx.core.app.ActivityCompat

class MyLocationManager(var logger: ILogger) {

    private lateinit var gpsListener: LocationListener
    private lateinit var locationManager: LocationManager
    lateinit var activity: Activity

    fun start() {

        if (ActivityCompat.checkSelfPermission(
                activity,
                Manifest.permission.ACCESS_FINE_LOCATION
            ) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(
                activity,
                Manifest.permission.ACCESS_COARSE_LOCATION
            ) != PackageManager.PERMISSION_GRANTED
        ) {
            ActivityCompat.requestPermissions(
                activity,
                arrayOf(Manifest.permission.ACCESS_FINE_LOCATION),
                REQUEST_LOCATION_PERMISSION
            )
        }

        locationManager = activity.getSystemService(LOCATION_SERVICE) as LocationManager

        gpsListener = LocationListener { location ->
            logger.log(
                        "\nLat: " + location.latitude.toString()
                        + "\nLon: " + location.longitude.toString()
                        + "\nAltitude" + location.altitude.toString()
            )
        }

        locationManager.requestLocationUpdates(
            LocationManager.GPS_PROVIDER,
            1000L,
            0f,
            gpsListener
        )

    }

    fun stop() {
        locationManager.removeUpdates(gpsListener)
    }

    companion object {
        const val REQUEST_LOCATION_PERMISSION = 123
    }
}