package com.example.testsandbox

import android.os.Bundle
import android.widget.ScrollView
import android.widget.TextView
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import com.example.testsandbox.databinding.ActivityMainBinding

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding
    private lateinit var tvLog: TextView
    private lateinit var scrollLog: ScrollView
    private lateinit var myLocationManager: MyLocationManager
    private val maxLines = 500

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        setContentView(R.layout.activity_main)

        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        tvLog = findViewById(R.id.tvLog)
        scrollLog = findViewById(R.id.scrollLog)


        val logger = Logger()
        logger.scrollLog = scrollLog
        logger.tvLog = tvLog
        logger.maxLines = maxLines

        myLocationManager = MyLocationManager(logger)
        myLocationManager.activity = this

        var isSendingStartLocationManager = false
        binding.btnStartLocationManager.setOnClickListener {
            logger.log("\n" + binding.btnStartLocationManager.text)

            isSendingStartLocationManager = !isSendingStartLocationManager
            if (isSendingStartLocationManager) {
                binding.btnStartLocationManager.text = "Stop LocationManager"
                myLocationManager.start()
            } else {
                binding.btnStartLocationManager.text = "Start LocationManager"
                myLocationManager.stop()
            }
        }
    }

}