using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using ObsStudioTest.Logger;
using ObsStudioTest.ObsStudio;

namespace ObsStudioTest;

internal static class Program
{
    /// <summary>
    ///  The main entry point for the application.
    /// </summary>
    [STAThread]
    static void Main()
    {
        // To customize application configuration such as set high DPI settings or default font,
        // see https://aka.ms/applicationconfiguration.
        ApplicationConfiguration.Initialize();

        using IHost host = Host.CreateDefaultBuilder()
            .ConfigureAppConfiguration((ctx, config) =>
            {
                config.AddJsonFile("appSettings.json", optional: false, reloadOnChange: true);
            })
            .ConfigureServices((ctx, services) =>
            {
                services.AddOptions<ObsOptions>()
                    .Bind(ctx.Configuration.GetSection(ObsOptions.SectionName))
                    .Validate(o => o.Uri is not null, "ObsOptions:Uri ist erforderlich.")
                    .ValidateOnStart();

                services.AddSingleton<FileLoggerAsync>(sp =>
                {
                    var exePath = Environment.ProcessPath ?? Application.ExecutablePath;
                    return new FileLoggerAsync
                    {
                        LoggerPath = Path.ChangeExtension(exePath, ".log")
                    };
                });
                services.AddSingleton<TextBoxLogger>();
                services.AddSingleton<ILogger>(sp => sp.GetRequiredService<TextBoxLogger>());
                services.AddSingleton<FileAndTextBoxLogger>(sp =>
                    new FileAndTextBoxLogger(
                        sp.GetRequiredService<ILogger>(),
                        sp.GetRequiredService<FileLoggerAsync>()
                    ));

                services.AddSingleton<ILoggerAsync>(sp => sp.GetRequiredService<FileAndTextBoxLogger>());

                // Form via DI
                services.AddSingleton<Form1>();
            })
            .Build();

        var form = host.Services.GetRequiredService<Form1>();
        Application.Run(form);
    }
}