﻿using ObsStudioTest.Logger;

namespace ObsStudioTest.ObsStudio;

public sealed class ObsVideoRecorder(IObsClient obs, ObsOptions opt, ILoggerAsync loggerAsync) : IVideoRecorder
{
    public async Task StartAsync(StartStopRecordingCommand command, CancellationToken ct = default)
    {
        var format = BuildFilenameFormat(command, opt.RecordDirectory) ?? opt.FilenameFormatting;
        await loggerAsync.Log($"Starting recording with filename format: {format}");

        if (!string.IsNullOrWhiteSpace(opt.RecordDirectory))
        {
            try
            {
                await obs.SendAsync("SetRecordDirectory", new { recordDirectory = opt.RecordDirectory }, ct);
                await loggerAsync.Log($"Set recording directory to: {opt.RecordDirectory}");
            }
            catch
            {
                await obs.SendAsync("SetProfileParameter", new
                {
                    parameterCategory = "SimpleOutput",
                    parameterName = "FilePath",
                    parameterValue = opt.RecordDirectory
                }, ct);
            }
        }

        try
        {
            await obs.SendAsync("SetProfileParameter", new
            {
                parameterCategory = "Output",
                parameterName = "FilenameFormatting",
                parameterValue = format
            }, ct);
        }
        catch
        {
        }

        await obs.SendAsync("StartRecord", null, ct);
    }

    public Task StopAsync(CancellationToken ct = default)
        => obs.SendAsync("StopRecord", null, ct);

    private static string? BuildFilenameFormat(StartStopRecordingCommand command, string? recordDirectory)
    {
        var testName = command.FileName;
        if (string.IsNullOrWhiteSpace(testName)) return null;

        var fileExtension = ".mp4";
        var candidateStem = testName;
        int i = 0;
        while (File.Exists(Path.Combine(recordDirectory ?? throw new NullReferenceException("recordDirectory is empty!"), candidateStem + fileExtension)))
        {
            i++;
            candidateStem = $"{testName}_{i}";
        }

        return $"{candidateStem}";
    }
}