﻿using System.Diagnostics;

namespace ObsStudioTest.ObsStudio;

public static class ObsAutoStart
{
    public static bool IsObsRunning()
        => Process.GetProcessesByName("obs64").Any();

    public static bool HasEnoughDiskSpace(string recordDirectory, long minFreeBytes)
    {
        var root = Path.GetPathRoot(recordDirectory);
        if (string.IsNullOrWhiteSpace(root))
            return false;

        var drive = new DriveInfo(root);
        return drive.AvailableFreeSpace >= minFreeBytes;
    }

    public static bool TryStartObs(string obsExePath)
    {
        try
        {
            if (IsObsRunning()) return true;

            var exeDir = Path.GetDirectoryName(obsExePath);
            Process.Start(new ProcessStartInfo
            {
                FileName = obsExePath,
                WorkingDirectory = exeDir,
                UseShellExecute = false
            });

            return true;
        }
        catch
        {
            return false;
        }
    }
}