﻿namespace ObsStudioTest.Logger;

public static class LoggerExtensions
{
    extension(ILoggerAsync loggerAsync)
    {
        public async Task Log(string message) =>
            await loggerAsync.Log(new LogEntry(LoggingEventType.Information, message));

        public async Task Log(Exception ex) =>
            await loggerAsync.Log(new LogEntry(LoggingEventType.Error, ex.Message, ex));
    }
}