﻿namespace ObsStudioTest.Logger;

public class FileLoggerAsync: ILoggerAsync
{
    public string? LoggerPath;

    public async Task Log(LogEntry entry)
    {
        string logMessage = $@"[{entry.Severity}] {DateTimeOffset.Now:yyyy-MM-dd HH:mm:ss.fff} {entry.Message} {entry.Exception} {Environment.NewLine}";
        if (LoggerPath is not null)
        {
            try
            {
                await File.AppendAllTextAsync(LoggerPath, logMessage);
            }
            catch (Exception e)
            {
                string loggerName = Path.GetFileNameWithoutExtension(LoggerPath);
                string loggerFileType = Path.GetExtension(LoggerPath);
                string? loggerPath = Path.GetDirectoryName(LoggerPath);
                loggerName = loggerName + "2" + loggerFileType;
                loggerName = Path.Combine(Path.GetDirectoryName(loggerPath) ?? string.Empty, loggerName);

                await File.AppendAllTextAsync(loggerName, e.Message);
            }
        }
        else
        {
            throw new NullReferenceException("LoggerPath is empty!");
        }
        
    }
}