using Microsoft.Extensions.Options;
using ObsStudioTest.Logger;
using ObsStudioTest.ObsStudio;

namespace ObsStudioTest;

public partial class Form1 : Form
{
    private readonly IVideoRecorder _videoRecorder;
    private readonly ILoggerAsync _loggerAsync;

    public Form1(IOptions<ObsOptions> obsOptions, FileAndTextBoxLogger loggerAsync)
    {
        InitializeComponent();

        var obs = obsOptions.Value;
        loggerAsync.TextBox = tbLog;
        _loggerAsync = loggerAsync;

        _videoRecorder = new ObsVideoRecorder(new ObsWebSocketClient(obs, _loggerAsync), obs, _loggerAsync);
    }

    private async void btnStart_Click(object sender, EventArgs e)
    {
        tbLog.Clear();
        StartStopRecordingCommand startStopRecordingCommand = new StartStopRecordingCommand
        {
            FileName = "test.mp4"
        };
        await _videoRecorder.StartAsync(startStopRecordingCommand);
    }

    private async void btnStop_Click(object sender, EventArgs e)
    {
        {
            try
            {
                await _videoRecorder.StopAsync();
            }
            catch (Exception ex)
            {
                await _loggerAsync.Log($"Video stop failed (ignored): {ex}");
            }
        }
    }
}