/*global google, $*/
(function (){
    "use strict";
 
    var mapOptions,
        mapCanvas,
        map;
		
    mapOptions = {
        zoom: 13,
        center: { lat: 50.7308924, lng: 7.0969354},
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
 
    mapCanvas = document.getElementById('map-canvas');
 
    if (!map) {
        map = new google.maps.Map(mapCanvas, mapOptions);
    }
	
	$.getJSON("test.json", function (data) {
		data.forEach(function (gpsNode) {
			var gpsLatLng = new google.maps.LatLng(gpsNode.lat, gpsNode.lng);
			
      var marker = new google.maps.Marker({
                    position: gpsLatLng,
                    map: map
                });			
		});
	});
 
}());