using Microsoft.EntityFrameworkCore;

namespace UpdateOrInsertRecordInDbFromParallelForEachAsync
{
    public partial class Form1 : Form
    {
        private CancellationTokenSource CancellationTokenSource { get; } = new();
        public Form1()
        {
            InitializeComponent();
        }

        private async void btnStartIProgress_Click(object sender, EventArgs e)
        {
            int recordCount = 0;
            IProgress<int> recordCountProgress = new Progress<int>(NumberOfFilesProcessedIProgress);
            IProgress<string> fileNameProgress = new Progress<string>(FileProcessedIProgress);
            int progressStep = 100;

            var options = new DbContextOptionsBuilder<FileNamesTestDbContext>()
                .UseSqlServer("Server=DESKTOP-OTNMA4I;Database=ImagesGps;User Id=sa;Password=genije;Encrypt=True;TrustServerCertificate=True;")
                .Options;

            await Parallel.ForEachAsync(Directory.EnumerateFiles(textBox1.Text, "*.*", SearchOption.AllDirectories), new ParallelOptions
            {
                CancellationToken = CancellationTokenSource.Token
            }
                , async (fileName, ct) =>
                {
                    await using var dbContext = new FileNamesTestDbContext(options);
                    FileNamesTestEntity fileNamesTestEntity = new FileNamesTestEntity();
                    fileNamesTestEntity.FileName = fileName;
                    dbContext.FileNamesTest.Add(fileNamesTestEntity);
                    await dbContext.SaveChangesAsync(ct);

                    recordCount = Interlocked.Increment(ref recordCount);
                    if (recordCount % progressStep == 0)
                    {
                        fileNameProgress.Report(fileName);
                        recordCountProgress.Report(recordCount);
                    }
                });

            MessageBox.Show("Done!");
        }

        private void FileProcessedIProgress(string fileName)
        {
            lblIProgressUiFileName.Text = fileName;
        }

        private void NumberOfFilesProcessedIProgress(int recordCount)
        {
            lblIProgressUiRecordCount.Text = $"Processed files: {recordCount}";
        }

        private void btnStopIProgress_Click(object sender, EventArgs e)
        {
            CancellationTokenSource.Cancel();
        }
    }
}
